//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "ISO15693Command.h"
#import "NSData+FastHex.h"

@implementation ISO15693Command

-(id) initWithData: (NSString *) cmd
{
    self = [super init];
    
    self.stringCommand = cmd;
    
    // Parse flag
    NSData *flagData = [NSData dataWithHexString: [cmd substringToIndex:2]];
    int i;
    [flagData getBytes: &i length: sizeof(i)];
    self.flags = i;
    
    // Parse Command Code
    unsigned int outVal;
    NSScanner* scanner = [NSScanner scannerWithString:[cmd substringWithRange: NSMakeRange (2, 2)]];
    [scanner scanHexInt:&outVal];
    self.commandCode = outVal;
    
    // Parse Requast Parameters
    self.requestParameters = [NSData dataWithHexString: [cmd substringFromIndex:4]];
    
    return self;
}

-(NSString *) getNSStringCommand{
    return self.stringCommand;
}


@end
